@extends('admin.dash_layouts.main')
@section('title', 'Dashboard page')
@section('content')

    <style>
        .defult {
            display: none;
        }
    </style>
    <div class="content-page">
        <div class="content">
            <div class="container-fluid">
                <div class="page-title-box">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="page-title">Tour Sales Manage</h4>
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="#">Dashboard</a>
                                </li>
                                <li class="breadcrumb-item">
                                    <a href="#">Tour Sales</a>
                                </li>
                                <li class="breadcrumb-item active">Add Tour Sales</li>
                            </ol>
                        </div>
                    </div>
                </div>

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="/tour-update" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-group row">
                                        <input type="hidden" name="InvoiceNumber" value="{{ $data->invoice }}">
                                        <label for="name" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" id="name" name="name"
                                                value="{{ $data->name }}" required>
                                            <input class="form-control" readonly type="hidden"
                                                value="{{ $data->clientid }}" name="clientid" required>
                                            <input type="hidden" name="id" value="{{ $data->id }}">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="email" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="email" id="email" name="email"
                                                value="{{ $data->email }}" required>
                                        </div>
                                    </div>


                                    <h4 class="mt-0 header-title">Hotels</h4>
                                    <div class="dynamic-table">
                                        <table class="table table-bordered responsive" id="dynamic-table">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Hotel</th>
                                                    <th>Special Note</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($hotels as $index => $hotel)
                                                    <tr>
                                                        <td>
                                                            <input class="form-control" type="date" required
                                                                name="date[{{ $index }}]"
                                                                value="{{ $hotel->date }}">
                                                            <input type="hidden" name="day[{{ $index }}]" required
                                                                value="{{ $hotel->day }}">
                                                            <div class="weatherdispay"></div>
                                                            <br>
                                                            <button class="weather  btn btn-secondary">Weather</button>
                                                        </td>
                                                        <td>

                                                            Destination<input class="form-control pac-target-input"
                                                                type="text" required name="h_place[{{ $index }}]"
                                                                value="{{ $hotel->h_place }}">
                                                            <div class="newhotel">

                                                                @if ($hotel->hotel !== null)
                                                                    <div class="newhotel"> <br>
                                                                        Hotel Name<input class="form-control" type="text"
                                                                            name="hotel[{{ $index }}]"
                                                                            value="{{ $hotel->hotel }}">
                                                                        Contact<input class="form-control" type="text"
                                                                            name="h_contact[{{ $index }}]"
                                                                            value="{{ $hotel->h_contact }}">
                                                                        Address<input class="form-control" type="text"
                                                                            name="h_address[{{ $index }}]"
                                                                            value="{{ $hotel->h_address }}">
                                                                        Price<input class="form-control" type="text"
                                                                            name="h_price[{{ $index }}]"
                                                                            value="{{ $hotel->h_price }}">
                                                                    </div>
                                                                @else
                                                                    <div class=" defult"> <br>
                                                                        Hotel Name<input class="form-control "
                                                                            type="text"
                                                                            name="hotel[{{ $index }}] ">
                                                                        <br> Contact <input class="form-control "
                                                                            type="text"
                                                                            name="h_contact[{{ $index }}] "><br>
                                                                        Address <input class="form-control " type="text"
                                                                            name="h_address[{{ $index }}] ">
                                                                        <br> Price<input class="form-control "
                                                                            type="text"
                                                                            name="h_price[{{ $index }}] "> <br>
                                                                    </div>
                                                                @endif






                                                            </div> <br> <button
                                                                class="hotel-btn btn btn-secondary">Hotel</button>
                                                        </td>

                                                        <td>
                                                            <input class="form-control" type="text"
                                                                name="h_note[{{ $index }}]"
                                                                value="{{ $hotel->h_note }}">
                                                        </td>
                                                        <td>
                                                            @if ($index === 0)
                                                                <button class="btn btn-success" id="add-row">Add
                                                                    Row</button>
                                                            @else
                                                                <button class="delete-row btn btn-danger">Delete</button>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-2 col-form-label">Detail</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" value="{{ $data->deatil }}" type="text"
                                                placeholder=" " name="deatil">
                                        </div>
                                    </div>



                                    <div class="form-group row">
                                        <label for="price" class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" id="price" name="price"
                                                value="{{ $data->price }}" placeholder=" ">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label for="pre_paid" class="col-sm-2 col-form-label">Pre Paid</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" id="pre_paid" name="prepaid"
                                                value="{{ $data->prepaid }}" placeholder=" ">
                                        </div>
                                    </div>
                                    <table class="table table-bordered responsive" id="dynamic-invoice">
                                        <thead>
                                            <tr>
                                                <th>Invoice</th>
                                                <th>Amount</th>
                                                <th>Action <button class="btn btn-warning" id="add-invoice-row">Add
                                                        Row</button></th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($invoicerow as $row)
                                                <tr>
                                                    <td><input type="text" class="form-control "
                                                            value="{{ $row->detail }}"
                                                            name="invoice[{{ $loop->index }}]"></td>
                                                    <td><input type="text" class="form-control "
                                                            value="{{ $row->amount }}"
                                                            name="amount[{{ $loop->index }}]"></td>
                                                    <td><button class="delete-row btn btn-danger">Delete</button></td>


                                                </tr>
                                            @endforeach

                                        </tbody>
                                    </table>

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit"
                                                class="btn btn-primary waves-effect waves-light">Submit</button>
                                            <button type="reset"
                                                class="btn btn-secondary waves-effect m-l-5">Cancel</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="map" style="height: 500px; width: 100%;margin-bottom:60px;"></div>

    <?php
    $itineraryArray = json_decode($data->itinerary, true);
    $itineraryJSON = json_encode($itineraryArray);
    ?>
    <script>
        var map;
        var directionsService;
        var directionsRenderer;
        var locationNames = <?php echo $itineraryJSON; ?>;

        console.log(locationNames);

        function initMap() {
            map = new google.maps.Map(document.getElementById("map"), {
                zoom: 5,
            });

            directionsService = new google.maps.DirectionsService();
            directionsRenderer = new google.maps.DirectionsRenderer({
                map: map,
            });

            updateDirections();
        }

        function updateDirections() {
            var origin = locationNames[0];
            var destination = locationNames[locationNames.length - 1];
            var waypoints = locationNames.slice(1, -1);

            var waypointsArray = waypoints.map(function(waypoint) {
                return {
                    location: waypoint,
                    stopover: true,
                };
            });

            var request = {
                origin: origin,
                destination: destination,
                waypoints: waypointsArray,
                travelMode: google.maps.TravelMode.DRIVING,
            };

            directionsService.route(request, function(result, status) {
                if (status == google.maps.DirectionsStatus.OK) {
                    directionsRenderer.setDirections(result);
                }
            });
        }
    </script>

    <script>
        function loadScript() {
            var script = document.createElement("script");
            script.src =
                "https://maps.googleapis.com/maps/api/js?key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4&libraries=places&callback=initMap";
            script.async = true;
            document.head.appendChild(script);
        }

        window.onload = loadScript;
    </script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            // Function to initialize Autocomplete for a specific row
            function initializeAutocompleteForNewRow(row) {
                var destinationInput = row.find('.pac-target-input')[0];
                var autocomplete = new google.maps.places.Autocomplete(destinationInput, {
                    componentRestrictions: {
                        country: 'LK' // 'LK' is the country code for Sri Lanka
                    }
                });
            }

            // Initialize Autocomplete for existing rows
            $('.pac-target-input').each(function() {
                initializeAutocompleteForNewRow($(this).closest('tr'));
            });

            var i = {{ count($hotels) }}; // Initialize i to the count of existing rows
            var d = {{ count($hotels) }} + 1;

            $('#dynamic-table').on('click', '.weather', function(event) {
                event.preventDefault();
                var row = $(this).closest('tr');
                var date = row.find('input[name^="date["]').val();
                var destination = row.find('.pac-target-input').val();
                var weatherDisplay = row.find('.weatherdispay');
                // Use the Google Places API to get the place details, including latitude and longitude
                var geocoder = new google.maps.Geocoder();

                geocoder.geocode({
                    'address': destination
                }, function(results, status) {
                    if (status === 'OK') {
                        var location = results[0].geometry.location;
                        var lat = location.lat();
                        var lon = location.lng();

                        var dateObj = new Date(date + ' 15:00:00');
                        var dt = dateObj.getTime() / 1000;

                        const currentDate = new Date().toJSON().slice(0, 10);
                        const currentDateObject = new Date(currentDate);
                        const futureDateObject = new Date(currentDateObject);
                        futureDateObject.setDate(currentDateObject.getDate() + 4);
                        const futureDateString = futureDateObject.toJSON().slice(0, 10);
                        var apiKey = "e7e9cc3e59e45f90b4c8b7bddcd88e48";

                        if (date > futureDateString) {
                            var apiUrl =
                                "https://api.openweathermap.org/data/3.0/onecall/day_summary?lat=" +
                                lat +
                                "&lon=" + lon + "&date=" + date + "&appid=" + apiKey;
                            $.get(apiUrl, function(data) {
                                // Access the properties correctly from the 'data' object
                                var cloud_cover = data.cloud_cover.afternoon;
                                var humidity = data.humidity.afternoon;
                                var mintemperature = data.temperature.min;
                                var maxtemperature = data.temperature.max;
                                var pressure = data.pressure.afternoon;
                                var maxwind = data.wind.max.speed;

                                // Find the 'weatherdispay' element within the current row
                                var weatherDisplay = row.find('.weatherdispay');

                                // Display weather information in the 'weatherdispay' element of the current row
                                weatherDisplay.html('Cloud Cover: ' + cloud_cover +
                                    '<br>Humidity: ' + humidity +
                                    '<br>Min Temperature: ' + mintemperature +
                                    '<br>Max Temperature: ' + maxtemperature +
                                    '<br>Pressure: ' + pressure +
                                    '<br>Max Wind: ' + maxwind);
                            });
                        } else {
                            var apiUrl =
                                "https://api.openweathermap.org/data/3.0/onecall/timemachine?lat=" +
                                lat +
                                "&lon=" + lon + "&dt=" + dt + "&appid=" + apiKey;

                            $.get(apiUrl, function(data) {

                                var weatherData = data.data[0].weather;
                                var main = weatherData[0].main;
                                var description = weatherData[0].description;
                                console.log(data);
                                // Find the 'weatherdispay' element within the current row


                                // Display weather information in the 'weatherdispay' element
                                weatherDisplay.html('Weather: ' + main + ', ' +
                                    description);
                            });
                        }
                    } else {
                        console.error("Geocoding failed: " + status);
                    }
                });
            });

            // Add Row button click event
            $('#add-row').click(function(event) {
                event.preventDefault();

                var newRow = $('<tr>');
                newRow.append('<td>Date<input class="form-control" type="date" required name="date[' + i +
                    ']"> <input type="hidden" name="day[' + i + ']" value="' + d +
                    '">   <div class="weatherdispay"></div> <br> <button class="weather btn btn-secondary">weather</button></td>'
                );
                newRow.append(
                    '<td>Destination<input class="form-control pac-target-input" type="text"  name="h_place[' +
                    i +
                    ']" > <div class="newhotel"> <div class="newhotel"> <br> Hotel Name<input class="form-control" type="text"  name="hotel[' +
                    i +
                    ']" > Contact<input class="form-control" type="text"  name="h_contact[' +
                    i +
                    ']" > Address<input class="form-control" type="text"  name="h_address[' +
                    i + ']" > Price<input class="form-control" type="text"  name="h_price[' +
                    i +
                    ']" > </div> </div> <br> <button class="hotel-btn btn btn-secondary">Hotel</button></td>'
                );
                newRow.append('<td><input class="form-control" type="text" name="h_note[' + i +
                    ']"></td>');
                newRow.append('<td><button class="delete-row btn btn-danger">Delete</button></td>');

                $('#dynamic-table tbody').append(newRow);

                // Initialize Autocomplete for the new row
                initializeAutocompleteForNewRow(newRow);

                i++;
                d++;
            });

            // Delete row button click event
            $('#dynamic-table').on('click', '.delete-row', function(event) {
                event.preventDefault();
                $(this).closest('tr').remove();
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            var t = {{ count($invoicerow) }};;
            $('#add-invoice-row').click(function() {
                event.preventDefault();
                t++;

                const newRow = `
                    <tr>
                        <td><input class="form-control" type="text" name="invoice[${t}]"></td>
                        <td><input class="form-control" type="text" name="amount[${t}]"></td>
                        <td><button class="delete-row">Delete</button></td>
                       
                    </tr>
                `;
                $('#dynamic-invoice tbody').append(newRow);
            });

            // Event delegation for dynamically added elements
            $('#dynamic-invoice').on('click', '.delete-row', function() {
                $(this).closest('tr').remove();
            });

            $('#dynamic-table').on('click', '.hotel-btn', function() {
                event.preventDefault();


                var row = $(this).closest('tr');


                var newHotelSection = row.find('.newhotel');

                newHotelSection.toggle();

                var defult = row.find('.defult');

                defult.show();


                if (!newHotelSection.is(':visible')) {

                    newHotelSection.find('input').val('');
                }
            });
        });
    </script>

@endsection
